/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import oracle.bi.webservices.v6.QueryResults;
import oracle.bi.webservices.v6.ReportEditingServiceLocator;
import oracle.bi.webservices.v6.ReportEditingServiceSoap;
import oracle.bi.webservices.v6.ReportRef;
import oracle.bi.webservices.v6.SAWSessionServiceLocator;
import oracle.bi.webservices.v6.SAWSessionServiceSoap;
import oracle.bi.webservices.v6.XMLQueryExecutionOptions;
import oracle.bi.webservices.v6.XMLQueryOutputFormat;
import oracle.bi.webservices.v6.XmlViewServiceLocator;
import oracle.bi.webservices.v6.XmlViewServiceSoap;
import org.apache.commons.lang.StringUtils;

public class LoadSimulation {
    public String[] strUserSession = new String[2000];
    public String[] strUser = new String[2000];
    public int cntActiveSessions = 0;
    private String strHostName;
    private String strPortNo;
    private String strRepPath;
    private String strDefaultPwd;
    private String strSessionService;
    private String XmlViewService;
    private String strReportEditingService;
    private SAWSessionServiceSoap sawsessionservice;
    private ReportRef repRef;
    private XMLQueryExecutionOptions execOpt;
    private XmlViewServiceSoap xmlviewservice;
    private int cntExecThreads;

    public LoadSimulation(String strHostName, String strPortNo, String strRepPath, String strDefaultPwd) {
        this.strHostName = strHostName;
        this.strPortNo = strPortNo;
        this.strRepPath = strRepPath;
        this.strDefaultPwd = strDefaultPwd;
        this.strSessionService = "http://" + strHostName + ":" + strPortNo + "/analytics/saw.dll?SoapImpl=nQSessionService";
        this.XmlViewService = "http://" + strHostName + ":" + strPortNo + "/analytics/saw.dll?SoapImpl=xmlViewService";
        this.strReportEditingService = "http://" + strHostName + ":" + strPortNo + "/analytics/saw.dll?SoapImpl=reportService";
        try {
            this.sawsessionservice = this.getSessionService();
            this.repRef = new ReportRef(strRepPath, "");
            this.execOpt = new XMLQueryExecutionOptions(false, 100, true, true, "");
            this.xmlviewservice = this.getXmlViewService();
        }
        catch (Exception ex) {
            System.out.println("~~" + ex.getMessage());
        }
    }

    private void assertNotNull(String sessionID) {
        if (sessionID == null) {
            System.out.println("Assertion failed: String null");
            System.exit(-1);
        }
    }

    private XmlViewServiceSoap getXmlViewService() throws ServiceException, MalformedURLException {
        XmlViewServiceSoap result = null;
        XmlViewServiceLocator locator = new XmlViewServiceLocator();
        result = locator.getXmlViewServiceSoap(new URL(null, this.XmlViewService, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                URL clone_url = new URL(url.toString());
                HttpURLConnection clone_urlconnection = (HttpURLConnection)clone_url.openConnection();
                clone_urlconnection.setConnectTimeout(360000);
                clone_urlconnection.setReadTimeout(360000);
                return clone_urlconnection;
            }
        }));
        return result;
    }

    private SAWSessionServiceSoap getSessionService() throws ServiceException {
        SAWSessionServiceSoap result = null;
        SAWSessionServiceLocator locator = new SAWSessionServiceLocator();
        locator.setSAWSessionServiceSoapEndpointAddress(this.strSessionService);
        result = locator.getSAWSessionServiceSoap();
        return result;
    }

    private ReportEditingServiceSoap getReportEditingService() throws ServiceException, MalformedURLException {
        ReportEditingServiceSoap result = null;
        ReportEditingServiceLocator locator = new ReportEditingServiceLocator();
        result = locator.getReportEditingServiceSoap(new URL(this.strReportEditingService));
        return result;
    }

    public String initializeSession(String strName, String strPwd) {
        String sessionID = null;
        try {
            sessionID = this.sawsessionservice.logon(strName, strPwd);
            this.assertNotNull(sessionID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sessionID;
    }

    public String destroySession(String sessionID) {
        try {
            this.sawsessionservice.logoff(sessionID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sessionID;
    }

    public void trackThreads() {
        ++this.cntExecThreads;
        if (this.cntExecThreads == this.cntActiveSessions) {
            this.DestroyUserSessions();
        }
    }

    public void executeQueries() {
        try {
            System.out.println("Invoking Queries..");
            this.cntExecThreads = 0;
            int i = 0;
            while (i < this.cntActiveSessions) {
                new execQueryThread(i);
                if (i % 100 == 0 && i > 0) {
                    System.out.println("Queries initiated: " + i);
                    Thread.sleep(5000L);
                }
                ++i;
            }
            System.out.println("Total queries initiated: " + this.cntActiveSessions);
        }
        catch (Exception ex) {
            System.out.println("~~" + ex.getMessage());
        }
    }

    public void CreateUserSessions(String fileName) {
        try {
            FileInputStream fstream = new FileInputStream(fileName);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = null;
            System.out.println("\n----------------------------------------------");
            System.out.println("Creating User Sessions..");
            System.out.flush();
            this.cntActiveSessions = 0;
            while ((strLine = br.readLine()) != null) {
                this.strUser[this.cntActiveSessions] = strLine;
                this.strUserSession[this.cntActiveSessions] = this.initializeSession(strLine, this.strDefaultPwd);
                ++this.cntActiveSessions;
                if (this.cntActiveSessions % 100 == 0) {
                    System.out.println("\t- Active Sessions: " + this.cntActiveSessions);
                }
                if (this.cntActiveSessions < 2000) continue;
                System.out.println("NOTE: Max sessions is set to 2000, can't create any more sessions. Proceeding with created sessions");
                break;
            }
            in.close();
            System.out.println("Total active sessions: " + this.cntActiveSessions);
        }
        catch (Exception ex) {
            System.out.println("~" + ex.getMessage());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        System.out.println("Time: " + dateFormat.format(new Date()) + "\n");
    }

    public void DestroyUserSessions() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        System.out.println("\nTime: " + dateFormat.format(new Date()));
        System.out.println("Cleaning up User Sessions..");
        try {
            System.out.println("\t- Remaining Active Sessions: " + this.cntActiveSessions);
            while (this.cntActiveSessions > 0) {
                this.destroySession(this.strUserSession[this.cntActiveSessions - 1]);
                if (this.cntActiveSessions % 100 == 0) {
                    System.out.println("\t- Remaining Active Sessions: " + this.cntActiveSessions);
                }
                --this.cntActiveSessions;
            }
            System.out.println("Completed User Sessions Cleanup");
        }
        catch (Exception ex) {
            System.out.println("~" + ex.getMessage());
        }
        System.out.println("----------------------------------------------\n");
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Proper Usage is: \njava -jar LoadSimulation.jar \"<hostname>\" \"<port number>\" \"<report path>\" \"<default password>\"");
            System.out.println("\nExample: \njava -jar LoadSimulation.jar \"localhost\" \"9704\" \"/shared/Load Simulation/Report Path\" \"Admin123\"");
            System.exit(0);
        }
        LoadSimulation o = new LoadSimulation(args[0], args[1], args[2], args[3]);
        o.CreateUserSessions("users_list.txt");
        o.executeQueries();
    }

    class execQueryThread
    implements Runnable {
        Thread t = new Thread(this);
        QueryResults res;
        int sessionIdx;

        execQueryThread(int i) {
            this.sessionIdx = i;
            this.t.start();
        }

        @Override
        public void run() {
            try {
                try {
                    this.res = LoadSimulation.this.xmlviewservice.executeXMLQuery(LoadSimulation.this.repRef, XMLQueryOutputFormat.SAWRowsetData, LoadSimulation.this.execOpt, null, LoadSimulation.this.strUserSession[this.sessionIdx]);
                    System.out.println("\tResults for Session:" + this.sessionIdx + "\tUsername:" + LoadSimulation.this.strUser[this.sessionIdx] + "\tRowcount:" + StringUtils.countMatches((String)this.res.getRowset(), (String)"<Row>"));
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    System.out.println("Thread #" + this.sessionIdx + "-" + LoadSimulation.this.strUser[this.sessionIdx] + "- error: " + ex.getMessage());
                    LoadSimulation.this.trackThreads();
                }
            }
            finally {
                LoadSimulation.this.trackThreads();
            }
        }
    }
}

